//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import "i2cMasterChannelViewController.h"

@interface i2cMasterChannelViewController ()

@end

@implementation i2cMasterChannelViewController

typedef enum : NSUInteger {
    LINE_POSITION_TOP,
    LINE_POSITION_BOTTOM
} LINE_POSITION;

bool isFirstCommand = true;

- (void)viewDidLoad {
    [super viewDidLoad];
    [self initViewUIElements];
}

- (IBAction)setI2cSlaveModeOptionSelected:(id)sender {
    [self SetI2cSlaveModeOptionSelectedView];
    
    [self DoInitSession];
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] setI2CSlave:^(NSData *aData) {
            /* ON SUCCESS CODE */
            NSLog(@"ON SUCCESS Ntag_fast_write :\n%@", aData);
            
        } onFailure:^(NSError *error) {
            /* ON FAILURE CODE */
            NSLog(@"ON FAILURE Ntag_fast_write :\n%@", error);
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}

- (IBAction)setI2cMasterModeOptionSelected:(id)sender {
    [self SetI2cMasterModeOptionSelectedView];
    
    [self DoInitSession];
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] setI2CMaster:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}

- (IBAction)setGPIOPWMModeOptionSelected:(id)sender {
    [self SetGPIOPWMModeOptionSelectedView];
    
    [self DoInitSession];
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] setGPIOPWM:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}

- (IBAction)getUseCaseCongifOptionSelected:(id)sender {
    CATransition * animation    = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden  = YES;
    
    [_defaultCommandsList.layer addAnimation:animation forKey:nil];
    _defaultCommandsList.hidden = YES;
    
    [self DoInitSession];
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] getUseCaseConfig:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}

- (IBAction)sendCommandButtonClick:(UIButton *)sender {
    [self DoInitSession];
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
            NSCharacterSet *chars = [[NSCharacterSet characterSetWithCharactersInString:@"0123456789ABCDEFabcdef"] invertedSet];
            BOOL isValid = (NSNotFound == [_writeCommandTextField.text rangeOfCharacterFromSet:chars].location);
            
            if(!isValid){
                
                [[NTAG5_NFC_LIB sharedInstance]customErrorMessage:str_wrong_custom_cmd message: ^(NSData *aData) {
                    
                } onFailure:^(NSError *error) {
                    
                }];
                return;
            }
            
            [[I2CMasterChannelUseCase sharedInstance] sendCustomCommand: _writeCommandTextField.text cmd:^(NSData *aData) {
                [[NTAG5_NFC_LIB sharedInstance] setMessage:str_success];

                [[NTAG5_NFC_LIB sharedInstance] close:^(NSData *aData) {} onFailure:^(NSError *error) {}];
            } onFailure:^(NSError *error) {
                
            }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}


- (void)DoInitSession {
    [[NTAG5_NFC_LIB sharedInstance] initSession:^(NSData *aData) {
        
    } onFailure:^(NSError *error) {
        
    }];
    
    NSLog(@"Waiting for connection...");
    while ([[NTAG5_NFC_LIB sharedInstance] isConnect] == 0){}
}

/*!
 *@abstract   sends the required commands depending on which default command is selected
 **/
- (void) sendDefaultCommands{
    
    if([_listTitle.text  isEqual: str_config_sensor] || isFirstCommand){
        isFirstCommand = false;
        [[I2CMasterChannelUseCase sharedInstance] configSensorI2CMaster:^(NSData *aData) {
            [self writeLog:cmd_setActiveModeI2CMasterCommand response:aData];
            
        } onFailure:^(NSError *error) {
            return;
        }];
        
        if([_listTitle.text  isEqual: str_config_sensor]){
            [[NTAG5_NFC_LIB sharedInstance] setMessage:str_success];
            [[NTAG5_NFC_LIB sharedInstance] close:^(NSData *aData) {} onFailure:^(NSError *error) {}];
        }
    }
    
    if([_listTitle.text  isEqual: str_get_temperature]){
        
        [[I2CMasterChannelUseCase sharedInstance] getTempI2CMaster:^(NSData *aData) {
            [self writeLog:cmd_readSRAMI2CMaster response:aData];
        } onFailure:^(NSError *error) {
            return;
        }];
        
    }else if([_listTitle.text  isEqual:str_get_accel_data_x_axis]){
        
        [[I2CMasterChannelUseCase sharedInstance] getAccelXI2CMaster:^(NSData *aData) {
            [self writeLog:cmd_setActiveModeI2CMasterCommand response:aData];
            
        } onFailure:^(NSError *error) {
            return;
        }];
        
    }else if([_listTitle.text  isEqual: str_get_accel_data_y_axis]){
        
        [[I2CMasterChannelUseCase sharedInstance] getAccelYI2CMaster:^(NSData *aData) {
            [self writeLog:cmd_readSRAMI2CMaster response:aData];
            
        } onFailure:^(NSError *error) {
            return;
        }];
        
    }else if([_listTitle.text  isEqual: str_get_accel_data_z_axis]){
        
        [[I2CMasterChannelUseCase sharedInstance] getAccelZI2CMaster:^(NSData *aData) {
            [self writeLog:cmd_readSRAMI2CMaster response:aData];
            
        } onFailure:^(NSError *error) {
            return;
        }];
        
    }else if([_listTitle.text  isEqual: str_get_mag_data_x_axis]){
        
        [[I2CMasterChannelUseCase sharedInstance] getMagnetXI2CMaster:^(NSData *aData) {
            [self writeLog:cmd_readSRAMI2CMaster response:aData];
            
        } onFailure:^(NSError *error) {
            return;
        }];
        
    }else if([_listTitle.text  isEqual: str_get_mag_data_y_axis]){
        
        [[I2CMasterChannelUseCase sharedInstance] getMagnetYI2CMaster:^(NSData *aData) {
            [self writeLog:cmd_readSRAMI2CMaster response:aData];
            
        } onFailure:^(NSError *error) {
            return;
        }];
        
    }else if([_listTitle.text  isEqual: str_get_mag_data_z_axis]){
        
        [[I2CMasterChannelUseCase sharedInstance] getMagnetZI2CMaster:^(NSData *aData) {
            [self writeLog:cmd_readSRAMI2CMaster response:aData];
            
        } onFailure:^(NSError *error) {
            return;
        }];
    }
}

/*---------------------- UI METHODS ----------------------*/

- (void) writeLog: (NSString *) cmd response: (NSData *) resp{
    NSMutableString * sbuf                          = [[Utils alloc] convertNSDataBytesToHexString:resp];
    NSString *log                                   = [NSString stringWithFormat: @"NFC -> %@ \nTAG <- 00%@", cmd, sbuf];
    
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        self-> _logsTextView.text                   = log;
        
        //Get the file path
        NSString *documentsDirectory = [NSSearchPathForDirectoriesInDomains (NSDocumentDirectory, NSUserDomainMask, YES) objectAtIndex:0];
        NSString *fileName = [documentsDirectory stringByAppendingPathComponent:@"I2CMasterLogs.txt"];

        //create file if it doesn't exist
        if(![[NSFileManager defaultManager] fileExistsAtPath:fileName])
            [[NSFileManager defaultManager] createFileAtPath:fileName contents:nil attributes:nil];

        //append text to file (you'll probably want to add a newline every write)
        NSFileHandle *file = [NSFileHandle fileHandleForUpdatingAtPath:fileName];
        [file seekToEndOfFile];
        [file writeData:[log dataUsingEncoding:NSUTF8StringEncoding]];
        [file closeFile];
    }];
}

- (void)initViewUIElements {
    _textView1.backgroundColor                      = UIColor.whiteColor;
    _textView1.userInteractionEnabled               = true;
    
    _textView2.backgroundColor                      = UIColor.whiteColor;
    _textView2.userInteractionEnabled               = true;
    
    _checkBox1.userInteractionEnabled               = true;
    _checkBox1.image                                = [UIImage imageNamed: img_checked_checkbox];
    
    _checkBox2.userInteractionEnabled               = true;
    _checkBox2.image                                = [UIImage imageNamed: img_unchecked_checkbox];
    
    _defaultCommandsTextView.backgroundColor        = UIColor.whiteColor;
    _defaultCommandsTextView.userInteractionEnabled = false;
    
    _defaultCommands.userInteractionEnabled         = true;
    _listTitle.text                                 = str_config_sensor;
    
    _commLogText.backgroundColor                    = UIColor.whiteColor;
    _commLogText.userInteractionEnabled             = false;
    
    _logsTextView.userInteractionEnabled            = false;
    _logsTextView.allowsEditingTextAttributes       = true;
    _logsTextView.editable                          = true;
    _logsTextView.textColor                         = UIColor.blackColor;
    
    _sendCommandButton.layer.cornerRadius           = 8;
    
    _writeCommandTextField.backgroundColor          = UIColor.whiteColor;
    
    _howToWriteCommandTitle.backgroundColor         = UIColor.whiteColor;
    
    _defaultCommandsList.userInteractionEnabled     = true;
    _defaultCommandsList.backgroundColor            = UIColor.whiteColor;
    _defaultCommandsList.layer.borderColor          = [UIColor lightGrayColor].CGColor;
    _defaultCommandsList.layer.borderWidth          = 0.75;
    
    [self addLine:_writeCommandTextField atPosition:LINE_POSITION_BOTTOM withColor:[UIColor darkGrayColor] lineWitdh:0.5];
    
    _configDropDownList.userInteractionEnabled      = true;
    _configDropDownList.backgroundColor             = UIColor.whiteColor;
    _configDropDownList.layer.borderColor           = [UIColor lightGrayColor].CGColor;
    _configDropDownList.layer.borderWidth           = 0.75;
    _configDropDownList.hidden                      = true;
    
    _isDefaultCommands                              = YES;
    
    isFirstCommand = true;
    
    _configSensorButton.layer.cornerRadius = 8;
    _getTempButton.layer.cornerRadius = 8;
    _getAccXButton.layer.cornerRadius = 8;
    _getAccYButton.layer.cornerRadius = 8;
    _getAccZButton.layer.cornerRadius = 8;
    
    _configSensorButton.titleLabel.textAlignment = UITextAlignmentCenter;
    _getTempButton.titleLabel.textAlignment = UITextAlignmentCenter;
    _getAccXButton.titleLabel.textAlignment = UITextAlignmentCenter;
    _getAccYButton.titleLabel.textAlignment = UITextAlignmentCenter;
    _getAccZButton.titleLabel.textAlignment = UITextAlignmentCenter;
    
    [self setAutoHideDropDownMenuListener];
}

- (IBAction)checkbox1Tap:(UIGestureRecognizer *)sender {
    if(_checkBox1.image == [UIImage imageNamed: img_unchecked_checkbox]){
        _checkBox1.image            = [UIImage imageNamed: img_checked_checkbox];
        _checkBox2.image            = [UIImage imageNamed: img_unchecked_checkbox];
        [self SetCheckbox1TapViews];
    }
}

- (IBAction)checkbox2Tap:(UIGestureRecognizer *)sender {
    if(_checkBox2.image == [UIImage imageNamed: img_unchecked_checkbox]){
        _checkBox2.image            = [UIImage imageNamed: img_checked_checkbox];
        _checkBox1.image            = [UIImage imageNamed: img_unchecked_checkbox];
        [self SetCheckbox2TapViews];
    }
}

- (IBAction)checkbox1TextTap:(UIGestureRecognizer *)sender {
    if(_checkBox1.image == [UIImage imageNamed: img_unchecked_checkbox]){
        _checkBox1.image            = [UIImage imageNamed: img_checked_checkbox];
        _checkBox2.image            = [UIImage imageNamed: img_unchecked_checkbox];
        [self SetCheckbox1TextTapViews];
    }
}

- (IBAction)checkbox2TextTap:(UIGestureRecognizer *)sender {
    if(_checkBox2.image == [UIImage imageNamed: img_unchecked_checkbox]){
        _checkBox2.image            = [UIImage imageNamed: img_checked_checkbox];
        _checkBox1.image            = [UIImage imageNamed: img_unchecked_checkbox];
        [self SetCheckbox2TextTapViews];
    }
}

- (IBAction)defaultCommandsDropDownTap:(UIGestureRecognizer *)sender {
    CATransition * animation        = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden      = YES;
    
    [_defaultCommandsList.layer addAnimation:animation forKey:nil];
    _defaultCommandsList.hidden     = NO;
}

- (IBAction)configureOptionSelected:(UIGestureRecognizer *)sender {
    _defaultCommandsList.hidden     = true;
    _listTitle.text                 = str_config_sensor;
}

- (IBAction)getTempOptionSelected:(UIGestureRecognizer *)sender {
    _defaultCommandsList.hidden     = true;
    _listTitle.text                 = str_get_temperature;
}

- (IBAction)getAccXOptionSelected:(UIGestureRecognizer *)sender {
    _defaultCommandsList.hidden     = true;
    _listTitle.text                 = str_get_accel_data_x_axis;
}

- (IBAction)getAccYOptionSelected:(UIGestureRecognizer *)sender {
    _defaultCommandsList.hidden     = true;
    _listTitle.text                 = str_get_accel_data_y_axis;
}

- (IBAction)getAccZOptionSelected:(UIGestureRecognizer *)sender {
    _defaultCommandsList.hidden     = true;
    _listTitle.text                 = str_get_accel_data_z_axis;
}

- (IBAction)getMagXOptionSelected:(UIGestureRecognizer *)sender {
    _defaultCommandsList.hidden     = true;
    _listTitle.text                 = str_get_mag_data_x_axis;
}

- (IBAction)getMagYOptionSelected:(UIGestureRecognizer *)sender {
    _defaultCommandsList.hidden     = true;
    _listTitle.text                 = str_get_mag_data_y_axis;
}

- (IBAction)getMagZOptionSelected:(UIGestureRecognizer *)sender {
    _defaultCommandsList.hidden     = true;
    _listTitle.text                 = str_get_mag_data_z_axis;
}

- (IBAction)navBarButtonClick:(id)sender {
    CATransition * animation        = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    
    if (_configDropDownList.hidden == false){
        _configDropDownList.hidden  = true;
    }else{
        _configDropDownList.hidden  = false;
    }
    
    [_defaultCommandsList.layer addAnimation:animation forKey:nil];
    _defaultCommandsList.hidden     = YES;
}

- (IBAction)configSensorButtonClick:(id)sender {
    

    [self DoInitSession];
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[I2CMasterChannelUseCase sharedInstance] configSensorI2CMaster:^(NSData *aData) {
            [self writeLog:cmd_setActiveModeI2CMasterCommand response:aData];
            
        } onFailure:^(NSError *error) {
            return;
        }];
        
        [[NTAG5_NFC_LIB sharedInstance] setMessage:str_success];
        [[NTAG5_NFC_LIB sharedInstance] close:^(NSData *aData) {} onFailure:^(NSError *error) {}];

        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}



- (IBAction)getTempButtonClick:(id)sender {
        [self DoInitSession];
        
        if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
            NSLog(@"Connected!!!");
            
            [[I2CMasterChannelUseCase sharedInstance] getTempI2CMaster:^(NSData *aData) {
                [self writeLog:cmd_readSRAMI2CMaster response:aData];
                
            } onFailure:^(NSError *error) {
                return;
            }];
            
        }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
            NSLog(@"Not connected!!!");
            
            [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
                
            } onFailure:^(NSError *error) {
                
            }];
        }
}

- (IBAction)getAccXButtonClick:(id)sender {
    [self DoInitSession];
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[I2CMasterChannelUseCase sharedInstance] getAccelXI2CMaster:^(NSData *aData) {
            [self writeLog:cmd_setActiveModeI2CMasterCommand response:aData];
            
        } onFailure:^(NSError *error) {
            return;
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}

- (IBAction)getAccYButtonClick:(id)sender {
    [self DoInitSession];
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");

        [[I2CMasterChannelUseCase sharedInstance] getAccelYI2CMaster:^(NSData *aData) {
            [self writeLog:cmd_readSRAMI2CMaster response:aData];
            
        } onFailure:^(NSError *error) {
            return;
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}

- (IBAction)getAccZButtonClick:(id)sender {
    [self DoInitSession];
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");

        [[I2CMasterChannelUseCase sharedInstance] getAccelZI2CMaster:^(NSData *aData) {
            [self writeLog:cmd_readSRAMI2CMaster response:aData];
            
        } onFailure:^(NSError *error) {
            return;
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            
        }];
    }
}
    
- (void)SetI2cSlaveModeOptionSelectedView {
    CATransition * animation        = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden      = YES;
    
    [_defaultCommandsList.layer addAnimation:animation forKey:nil];
    _defaultCommandsList.hidden     = YES;
}

- (void)SetI2cMasterModeOptionSelectedView {
    CATransition * animation    = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden  = YES;
    
    [_defaultCommandsList.layer addAnimation:animation forKey:nil];
    _defaultCommandsList.hidden = YES;
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden  = YES;
}

- (void)SetGPIOPWMModeOptionSelectedView {
    CATransition * animation    = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden  = YES;
    
    [_defaultCommandsList.layer addAnimation:animation forKey:nil];
    _defaultCommandsList.hidden = YES;
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden  = YES;
}

-(void)HideWhenTappedAnywhere{
    CATransition * animation            = [self StartAnimationTransition];
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden          = YES;
    
    [_defaultCommandsList.layer addAnimation:animation forKey:nil];
    _defaultCommandsList.hidden         = YES;
    
    [self.view endEditing:true];
}

- (void)setAutoHideDropDownMenuListener {
    UITapGestureRecognizer *singleTap   = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(HideWhenTappedAnywhere)];
    singleTap.numberOfTapsRequired      = 1;
    
    [self.MainView setUserInteractionEnabled:YES];
    [self.MainView addGestureRecognizer:singleTap];
}

- (void) addLine:(UIView *)view atPosition:(LINE_POSITION)position withColor:(UIColor *)color lineWitdh:(CGFloat)width {
    UIView *lineView                    = [[UIView alloc] init];
    [lineView setBackgroundColor:color];
    [lineView setTranslatesAutoresizingMaskIntoConstraints:NO];
    
    [view addSubview:lineView];
    
    NSDictionary *metrics               = @{@"width" : [NSNumber numberWithFloat:width]};
    NSDictionary *views                 = @{@"lineView" : lineView};
    
    [view addConstraints:[NSLayoutConstraint
                          constraintsWithVisualFormat:@"H:|[lineView]|"
                          options: 0
                          metrics:metrics
                          views:views]];
    
    switch (position) {
        case LINE_POSITION_TOP:
            [view addConstraints:[NSLayoutConstraint
                                  constraintsWithVisualFormat:@"V:|-0-[lineView(width)]"
                                  options: 0
                                  metrics:metrics
                                  views:views]];
            break;
            
        case LINE_POSITION_BOTTOM:
            [view addConstraints:[NSLayoutConstraint
                                  constraintsWithVisualFormat:@"V:[lineView(width)]|"
                                  options: 0
                                  metrics:metrics
                                  views:views]];
            break;
            
        default: break;
    }
}

- (void)SetCheckbox1TapViews {
    _defaultCommandsTextView.hidden = false;
    _writeCommandTextField.hidden   = true;
    _defaultCommands.hidden         = false;
    _howToWriteCommandTitle.hidden  = true;
    _writeComandImage.hidden        = true;
    _isDefaultCommands              = YES;
}

- (void)SetCheckbox2TapViews {
    _defaultCommandsTextView.hidden = true;
    _writeCommandTextField.hidden   = false;
    _defaultCommands.hidden         = true;
    _howToWriteCommandTitle.hidden  = false;
    _writeComandImage.hidden        = false;
    _isDefaultCommands              = NO;
}

- (void)SetCheckbox1TextTapViews {
    _defaultCommandsTextView.hidden = false;
    _writeCommandTextField.hidden   = true;
    _defaultCommands.hidden         = false;
    _howToWriteCommandTitle.hidden  = true;
    _writeComandImage.hidden        = true;
    _isDefaultCommands              = YES;
}

- (void)SetCheckbox2TextTapViews {
    _defaultCommandsTextView.hidden = true;
    _writeCommandTextField.hidden   = false;
    _defaultCommands.hidden         = true;
    _howToWriteCommandTitle.hidden  = false;
    _writeComandImage.hidden        = false;
    _isDefaultCommands              = NO;
}

- (CATransition *)StartAnimationTransition {
    CATransition *animation         = [CATransition animation];
    animation.type                  = kCATransitionReveal;
    animation.duration              = 0.1;
    return animation;
}
@end
